"use client";

import Image from "next/image";
import { Autoplay, Navigation, Pagination } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";
import 'swiper/css';
import 'swiper/css/autoplay';
import 'swiper/css/navigation';
import 'swiper/css/pagination';


function Slider() {
  return (
    <div className="flex items-center justify-center w-full">
      <Swiper
        modules={[Pagination, Autoplay, Navigation]}
        loop={true}
        autoplay={{ delay: 3000 }}
        pagination={{ clickable: true }}
        navigation={true}
        className="w-full h-[600px]"
    >
        <SwiperSlide>
            <Image src="/images/item_1.webp" alt="Slider Image 1" className="object-cover! h-[600px]!" width={1600} height={100}/>
        </SwiperSlide>
        <SwiperSlide>
            <Image src="/images/item_2.webp" alt="Slider Image 2" className="object-cover! h-[600px]!" width={1600} height={100}/>
        </SwiperSlide>
        <SwiperSlide>
            <Image src="/images/item_3.webp" alt="Slider Image 3" className="object-cover! h-[600px]!" width={1600} height={100}/>
        </SwiperSlide>
        <SwiperSlide>
            <Image src="/images/item_4.webp" alt="Slider Image 4" className="object-cover! h-[600px]!" width={1600} height={100}/>
        </SwiperSlide>
      </Swiper>
    </div>
  );
}

export default Slider
