import Image from "next/image";

interface Item {
  id: number;
  title: string;
  description: string;
}

const PostCard = () => {
  const items: Item[] = [
    { id: 1, title: "محصول ۱", description: "این محصول تازه و با کیفیت بالا، مناسب استفاده روزانه است." },
    { id: 2, title: "محصول ۲", description: "یک کالای محبوب از فروشگاه‌های زنجیره‌ای ما با بهترین قیمت." },
    { id: 3, title: "محصول ۳", description: "محصولی مطمئن و پرطرفدار که رضایت مشتریان را جلب می‌کند." },
    { id: 4, title: "محصول ۴", description: "یک انتخاب عالی برای مصرف‌کننده‌های هوشمند و خانواده‌ها." },
  ];

  return (
    <div className="w-full max-w-6xl mx-auto px-4 py-10">
      <h2 className="text-2xl font-semibold mb-6 text-gray-800">محصولات ویژه</h2>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
        {items.map((item) => (
          <div
            key={item.id}
            className="rounded-2xl border shadow-sm hover:shadow-md transition p-5 flex flex-col"
          >
            <div className="w-full h-56 rounded-xl mb-4 overflow-hidden">
              <Image
                src="/images/item_1.webp"
                alt={item.title}
                width={500}
                height={350}
                className="w-full h-full object-cover hover:scale-105 transition-transform duration-500 ease-in-out"
              />
            </div>

            <h3 className="text-lg font-semibold text-[#7a2d2d] mb-1">
              {item.title}
            </h3>

            <p className="text-sm text-[#8a4c4c] leading-relaxed">
              {item.description}
            </p>
          </div>
        ))}
      </div>
    </div>
  );
};

export default PostCard;
