'use client'


import { Menu, X } from "lucide-react"
import { Input } from "./ui/input"
import Link from "next/link"
import { useState } from "react";

const NavbarClient = () => {
    const [isAsideOpen, setIsAsideOpen] = useState(false);
  return (
    <div>
        <button
            className="md:hidden p-2 rounded bg-rose-100 text-rose-700"
            onClick={() => setIsAsideOpen(true)}
        >
            <Menu className="size-6" />
        </button>

      {isAsideOpen && (
        <div
          className="fixed inset-0 bg-black/40 z-40"
          onClick={() => setIsAsideOpen(false)}
        />
      )}

        <aside
            className={`fixed top-0 left-0 w-64 h-full bg-white shadow-xl z-50 p-6 transition-transform duration-300 ${
            isAsideOpen ? "translate-x-0" : "-translate-x-full"
        }`}>
          <div className="flex justify-between items-center mb-6">
            <span className="font-bold text-xl text-[#5a2a2a]">Menu</span>
            <button onClick={() => setIsAsideOpen(false)}>
              <X className="size-6 text-[#5a2a2a]" />
            </button>
          </div>

          <ul className="flex flex-col gap-4 text-[#5a2a2a] font-medium">
            <Link href="/" onClick={() => setIsAsideOpen(false)}>خانه</Link>
            <Link href="/about" onClick={() => setIsAsideOpen(false)}>درباره ما</Link>
            <Link href="/stores" onClick={() => setIsAsideOpen(false)}>فروشگاه‌های زنجیره‌ای</Link>
            <Link href="/services" onClick={() => setIsAsideOpen(false)}>خدمات</Link>
            <Link href="/analyse" onClick={() => setIsAsideOpen(false)}>تحلیل</Link>
            <Link href="/contact" onClick={() => setIsAsideOpen(false)}>تماس با ما</Link>
          </ul>

          <div className="mt-6">
            <Input
              type="text"
              placeholder="Search..."
              className="w-full bg-white border border-rose-300 text-[#5a2a2a] focus-visible:ring-rose-400"
            />
          </div>
        </aside>
    </div>
  )
}

export default NavbarClient
