import NavbarClient from './NavbarClient'
import { Input } from "@/components/ui/input";
import Image from "next/image";
import Link from "next/link";

const Navbar = () => {
  return (
      <header className="sticky top-0 z-50 bg-white shadow-sm">
        <nav className="flex justify-between items-center px-6 py-4 max-w-7xl mx-auto">

          <Link href="/" className="flex items-center gap-2">
            <Image src="/vercel.svg" alt="Logo" width={32} height={32} />
            <span className="font-semibold text-lg text-[#5a2a2a]">
              سیمین زرّین
            </span>
          </Link>

          <ul className="hidden md:flex gap-8 text-[#5a2a2a] font-normal">
            <li className="hover:text-rose-600 transition"><Link href="/">خانه</Link></li>
            <li className="hover:text-rose-600 transition"><Link href="/about">درباره ما</Link></li>
            <li className="hover:text-rose-600 transition"><Link href="/chain-stores">فروشگاه‌های زنجیره‌ای</Link></li>
            <li className="hover:text-rose-600 transition"><Link href="/services">خدمات</Link></li>
            <li className="hover:text-rose-600 transition"><Link href="/analyse">تحلیل</Link></li>
          </ul>

          <div className="hidden md:flex items-center gap-4">
            <Input
              type="text"
              placeholder="جستجو..."
              className="w-64 bg-white border border-rose-300 text-[#5a2a2a] focus-visible:ring-rose-400 focus-visible:ring-1"
            />
            <Link href="/contact" className="text-[#5a2a2a] hover:text-rose-600 transition">
              تماس با ما
            </Link>
          </div>

            <NavbarClient />
        </nav>
      </header>
  )
}

export default Navbar
