import Image from "next/image";
import Link from "next/link";

export default function Footer() {
  return (
    <footer className="bg-[#faf5f5] border-t border-rose-200 mt-12">
      <div className="max-w-7xl mx-auto px-6 py-12">

        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-10">

          <div>
            <div className="flex items-center gap-2 mb-4">
              <Image src="/vercel.svg" width={36} height={36} alt="Logo" />
              <span className="font-semibold text-xl text-[#5a2a2a]">فروشگاه کالاهای تندمصرف</span>
            </div>
            <p className="text-[#744b4b] text-sm leading-relaxed">
              شریک قابل اعتماد شما در تأمین کالاهای تندمصرف.
              کالاهای ضروری با کیفیت بالا، تحویل‌شده با دقت و سرعت
            </p>
          </div>

          <div>
            <h3 className="font-semibold text-[#5a2a2a] text-lg mb-4">دسترسی سریع</h3>
            <ul className="space-y-2 text-[#744b4b] text-sm">
              <li><Link href="/" className="hover:text-rose-600">خانه</Link></li>
              <li><Link href="/about" className="hover:text-rose-600">درباره ما</Link></li>
              <li><Link href="/stores" className="hover:text-rose-600">فروشگاه‌های زنجیره‌ای</Link></li>
              <li><Link href="/services" className="hover:text-rose-600">خدمات</Link></li>
            </ul>
          </div>

          <div>
            <h3 className="font-semibold text-[#5a2a2a] text-lg mb-4">خدمات مشتریان</h3>
            <ul className="space-y-2 text-[#744b4b] text-sm">
              <li><Link href="/contact" className="hover:text-rose-600">تماس با ما</Link></li>
              <li><Link href="/faq" className="hover:text-rose-600">سؤالات متداول</Link></li>
              <li><Link href="/shipping" className="hover:text-rose-600">اطلاعات ارسال</Link></li>
              <li><Link href="/returns" className="hover:text-rose-600">مرجوعی‌ها</Link></li>
            </ul>
          </div>

          <div>
            <h3 className="font-semibold text-[#5a2a2a] text-lg mb-4">به‌روز بمانید</h3>
            <p className="text-[#744b4b] text-sm mb-3">
              برای محصولات جدید و پیشنهادهای ویژه مشترک شوید
            </p>
            <form className="flex flex-col gap-3">
              <input
                type="email"
                placeholder="ایمیل خود را وارد کنید"
                className="px-3 py-2 rounded-md border border-rose-300 bg-white text-sm focus:outline-none focus:ring-1 focus:ring-rose-400"
              />
              <button
                type="submit"
                className="bg-rose-600 hover:bg-rose-700 text-white text-sm px-3 py-2 rounded-md transition"
              >
                عضویت
              </button>
            </form>
          </div>
        </div>

        <div className="border-t border-rose-200 my-8"></div>

        <div className="flex flex-col sm:flex-row justify-between items-center text-[#744b4b] text-sm">
          <p>© {new Date().getFullYear()} تمام حقوق محفوظ است</p>

          <div className="flex gap-4 mt-4 sm:mt-0">
            <Link href="#" className="hover:text-rose-600 transition">اینستاگرام</Link>
            <Link href="#" className="hover:text-rose-600 transition">لینکدین</Link>
            <Link href="#" className="hover:text-rose-600 transition">فیسبوک</Link>
          </div>
        </div>
      </div>
    </footer>
  );
}
