"use client";

import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import Image from "next/image";
import { Swiper, SwiperSlide } from "swiper/react";
import { Scrollbar, A11y, Keyboard } from "swiper/modules";


export default function AlbumCarousel({title}: {title?: string}) {
const items = [
    { id: 1, title: "محصولات گلرنگ", image: "/images/brands/golrang.webp" },
    { id: 2, title: "لبنیات و بستنی میهن", image: "/images/brands/mihan.webp" },
    { id: 3, title: "فرآورده‌های گوشتی و لبنی کاله", image: "/images/brands/kalleh.webp" },
    { id: 4, title: "نوشیدنی و آبمیوه سن‌ایچ", image: "/images/brands/sunich.webp" },
    { id: 5, title: "روغن‌های خوراکی اویلا", image: "/images/brands/oila.webp" },
    { id: 6, title: "محصولات پروتئینی ماهشام", image: "/images/brands/mahsham.webp" },
];

  return (
    <div className="w-full px-4 mt-4">
        {title && <h2 className="text-2xl font-bold mb-4 text-gray-800">{title}</h2>}
      <Swiper
        modules={[ Scrollbar, A11y, Keyboard]}
        keyboard={{ enabled: true }}
        spaceBetween={20}
        className="pb-10"
        breakpoints={{
          420: { slidesPerView: 1.7 },
          640: { slidesPerView: 3.2 },
          1024: { slidesPerView: 5.2 },
        }}
      >
        {items.map((item, i) => (
          <SwiperSlide key={item.id}>
            <div className={`rounded-2xl shadow-xl overflow-hidden bg-white mb-10 ${i == 0 && 'mr-2'} ${i == items.length -1 && 'ml-2'}`}>
              <Image
                width={200}
                height={200}
                src={item.image}
                alt={item.title}
                className="w-full h-56 object-cover border-b border-gray-100"
              />
              <div className="p-4">
                <h3 className="text-lg font-medium text-[#5a2a2a]">{item.title}</h3>
              </div>
            </div>
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
}
