// src/declarations.d.ts

/**
 * 💡 Fixes the TypeScript error:
 * "Cannot find module or type declarations for side-effect import of '*.css'"
 * * This tells TypeScript to treat any file ending in '.css' as a valid
 * module that can be imported without requiring specific type definitions.
 */

declare module '*.css' {
  // Use 'any' since we are only interested in the side-effect (loading the styles)
  // and the CSS file doesn't export any meaningful JavaScript value.
  const content: any;
  export default content;
}

// You can add other declarations here if needed (e.g., for images, SVG, etc.)

declare module 'swiper/css' {
  const content: any;
  export default content;
}

declare module 'swiper/css/navigation' {
  const content: any;
  export default content;
}

declare module 'swiper/css/pagination' {
  const content: any;
  export default content;
}

declare module 'swiper/css/autoplay' {
  const content: any;
  export default content;
}
/*
declare module '*.png' {
    const value: any;
    export default value;
}
*/
