import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import localfont from "next/font/local";
import "./globals.css";

const vazir = localfont({
  variable: "--font-vazir",
  src: [
    {
        path: "./fonts/vazir/Vazirmatn-RD-Thin.woff2",
        weight: "200",
        style: "normal",
    },
    {
        path: "./fonts/vazir/Vazirmatn-RD-ExtraLight.woff2",
        weight: "200",
        style: "normal",
    },
    {
        path: "./fonts/vazir/Vazirmatn-RD-Light.woff2",
        weight: "300",
        style: "normal",
    },
    {
        path: "./fonts/vazir/Vazirmatn-RD-Regular.woff2",
        weight: "400",
        style: "normal",
    },
    {
        path: "./fonts/vazir/Vazirmatn-RD-Medium.woff2",
        weight: "500",
        style: "normal",
    },
    {
        path: "./fonts/vazir/Vazirmatn-RD-SemiBold.woff2",
        weight: "600",
        style: "normal",
    },
    {
        path: "./fonts/vazir/Vazirmatn-RD-Bold.woff2",
        weight: "700",
        style: "normal",
    },
    {
        path: "./fonts/vazir/Vazirmatn-RD-ExtraBold.woff2",
        weight: "800",
        style: "normal",
    },
    {
        path: "./fonts/vazir/Vazirmatn-RD-Black.woff2",
        weight: "900",
        style: "normal",
    },
  ],
  display: "swap",
});

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "FMCG",
  description: "FMCG products showcase application",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased`}
      >
        {children}
      </body>
    </html>
  );
}
