export default function page() {
  const services = [
    {
      title: "توزیع محصولات",
      description:
        "توزیع سریع و کارآمد کالاهای تندمصرف در کانال‌های خرده‌فروشی و عمده‌فروشی.",
    },
    {
      title: "مدیریت زنجیره تأمین",
      description:
        "راهکارهای لجستیک و موجودی بهینه برای تضمین دسترسی همیشگی به محصولات.",
    },
    {
      title: "راهکارهای برند خصوصی",
      description:
        "پشتیبانی از توسعه محصولات با برند اختصاصی و شخصی‌سازی شده.",
    },
    {
      title: "حمایت از خرده‌فروشی",
      description:
        "ارائه کمک‌های ویژه به فروشگاه‌ها شامل تبلیغات و مدیریت کالاها.",
    },
    {
      title: "تحلیل بازار",
      description:
        "ارائه بینش و تحلیل‌های دقیق برای تصمیم‌گیری هوشمندانه شرکا.",
    },
    {
      title: "پشتیبانی مشتریان",
      description:
        "تیم‌های پاسخگو آماده ارائه کمک و پاسخ به پرسش‌ها و سفارش‌ها.",
    },
  ];

  return (
    <main className="min-h-screen bg-[#fff8f6]">
      <div className="max-w-6xl mx-auto px-4 py-16">

        <div className="text-center mb-14">
          <h1 className="text-3xl md:text-4xl font-bold text-[#5a2a2a] mb-3">
            خدمات ما
          </h1>
          <p className="text-[#8a4c4c] max-w-2xl mx-auto">
            ما راهکارهای جامع FMCG ارائه می‌دهیم که با هدف حمایت از رشد، کارایی و همکاری‌های بلندمدت طراحی شده‌اند.
          </p>
        </div>

        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
          {services.map((service, index) => (
            <div
              key={index}
              className="bg-white rounded-2xl border border-[#ffd9d2] p-6 shadow-sm hover:shadow-md transition"
            >
              <h3 className="text-lg font-semibold text-[#7a2d2d] mb-2">
                {service.title}
              </h3>
              <p className="text-sm text-[#8a4c4c] leading-relaxed">
                {service.description}
              </p>
            </div>
          ))}
        </div>

        <div className="mt-16 text-center">
          <p className="text-[#8a4c4c] mb-4">
            علاقه‌مند به همکاری با ما یا کسب اطلاعات بیشتر هستید؟
          </p>
          <a
            href="/contact"
            className="inline-block bg-rose-600 hover:bg-rose-700 text-white px-6 py-2 rounded-md transition"
          >
            تماس با ما
          </a>
        </div>
      </div>
    </main>
  );
}
