const page = () => {
  return (
    <main className="min-h-screen bg-[#fff8f6]">
      <div className="max-w-5xl mx-auto px-4 py-16">

        <div className="text-center mb-12">
          <h1 className="text-3xl md:text-4xl font-bold text-[#5a2a2a] mb-3">
            تماس با ما
          </h1>
          <p className="text-[#8a4c4c] max-w-xl mx-auto">
            سوال، نظر یا درخواست همکاری دارید؟
            خوشحال می‌شویم از شما بشنویم.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 gap-10">

          <div className="bg-white rounded-2xl border border-[#ffd9d2] p-6 shadow-sm">
            <h2 className="text-xl font-semibold text-[#7a2d2d] mb-4">
              اطلاعات تماس
            </h2>

            <div className="space-y-4 text-sm text-[#8a4c4c]">
              <p>
                <span className="font-medium text-[#7a2d2d]">آدرس:</span><br />
                خیابان مثال ۱۲۳، شهر، کشور
              </p>

              <p>
                <span className="font-medium text-[#7a2d2d]">تلفن:</span><br />
                +۹۸ (۰۲۱) ۱۲۳۴۵۶۷۸
              </p>

              <p>
                <span className="font-medium text-[#7a2d2d]">ایمیل:</span><br />
                contact@example.com
              </p>

              <p>
                <span className="font-medium text-[#7a2d2d]">ساعات کاری:</span><br />
                شنبه تا چهارشنبه، ۹ صبح تا ۶ بعدازظهر
              </p>
            </div>

            <div className="mt-6">
              <p className="text-sm text-[#8a4c4c]">
                در موارد فوری، لطفاً مستقیماً با ما تماس بگیرید.
              </p>
            </div>
          </div>

          <div className="bg-white rounded-2xl border border-[#ffd9d2] p-6 shadow-sm">
            <h2 className="text-xl font-semibold text-[#7a2d2d] mb-4">
              ارسال پیام
            </h2>

            <form className="space-y-4">
              <div>
                <label className="block text-sm text-[#7a2d2d] mb-1">
                  نام و نام خانوادگی
                </label>
                <input
                  type="text"
                  placeholder="نام شما"
                  className="w-full px-3 py-2 rounded-md border border-[#ffd9d2] focus:outline-none focus:ring-1 focus:ring-rose-400"
                />
              </div>

              <div>
                <label className="block text-sm text-[#7a2d2d] mb-1">
                  ایمیل
                </label>
                <input
                  type="email"
                  placeholder="you@example.com"
                  className="w-full px-3 py-2 rounded-md border border-[#ffd9d2] focus:outline-none focus:ring-1 focus:ring-rose-400"
                />
              </div>

              <div>
                <label className="block text-sm text-[#7a2d2d] mb-1">
                  موضوع
                </label>
                <input
                  type="text"
                  placeholder="موضوع"
                  className="w-full px-3 py-2 rounded-md border border-[#ffd9d2] focus:outline-none focus:ring-1 focus:ring-rose-400"
                />
              </div>

              <div>
                <label className="block text-sm text-[#7a2d2d] mb-1">
                  پیام
                </label>
                <textarea
                  rows={4}
                  placeholder="پیام خود را بنویسید..."
                  className="w-full px-3 py-2 rounded-md border border-[#ffd9d2] focus:outline-none focus:ring-1 focus:ring-rose-400 resize-none"
                />
              </div>

              <button
                type="submit"
                className="w-full bg-rose-600 hover:bg-rose-700 text-white font-medium py-2 rounded-md transition"
              >
                ارسال پیام
              </button>
            </form>
          </div>
        </div>
      </div>
    </main>
  );
}

export default page;
