import Image from "next/image";

export default function page() {
  return (
    <main className="min-h-screen bg-[#fff8f6]">
      <div className="max-w-6xl mx-auto px-4 py-16">

        <div className="text-center mb-14">
          <h1 className="text-3xl md:text-4xl font-bold text-[#5a2a2a] mb-3">
            درباره ما
          </h1>
          <p className="text-[#8a4c4c] max-w-2xl mx-auto">
            ما متعهد به ارائه کالاهای تندمصرف با کیفیت بالا هستیم و تمرکز ما بر
            قابلیت اطمینان، کارایی و رضایت مشتریان است.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">

          <div className="space-y-5 text-[#8a4c4c] leading-relaxed">
            <p>
              شرکت ما با هدف ساده‌سازی نیازهای روزمره تأسیس شد و با تأمین‌کنندگان
              معتبر همکاری می‌کند تا محصولات قابل اعتماد را به مصرف‌کنندگان و
              فروشندگان ارائه دهد.
            </p>
            <p>
              فعالیت‌های ما بر پایه شفافیت، ثبات و همکاری‌های بلندمدت بنا شده است.
              ما به‌طور مداوم در حوزه لجستیک، کنترل کیفیت و نوآوری سرمایه‌گذاری
              می‌کنیم تا پاسخگوی نیازهای در حال تغییر بازار باشیم.
            </p>
            <p>
              امروز با افتخار به مشتریان در مناطق مختلف خدمات ارائه می‌دهیم و
              تحویل سریع، قیمت رقابتی و خدمات قابل اعتماد را تضمین می‌کنیم.
            </p>
          </div>

          {/* Image */}
          <div className="w-full h-72 rounded-2xl overflow-hidden shadow-sm">
            <Image
              src="/images/item_1.webp"
              alt="درباره ما"
              width={600}
              height={400}
              className="w-full h-full object-cover"
            />
          </div>
        </div>

        <div className="mt-16 grid grid-cols-1 sm:grid-cols-3 gap-6">
          {[
            { title: "کیفیت", desc: "استانداردهای سخت‌گیرانه در تأمین و توزیع." },
            { title: "قابلیت اطمینان", desc: "تحویل منظم و قابل اعتماد." },
            { title: "رشد", desc: "رشد مشترک همراه با شرکا و مشتریان." },
          ].map((item, i) => (
            <div
              key={i}
              className="bg-white border border-[#ffd9d2] rounded-2xl p-6 text-center shadow-sm"
            >
              <h3 className="text-lg font-semibold text-[#7a2d2d] mb-2">
                {item.title}
              </h3>
              <p className="text-sm text-[#8a4c4c]">{item.desc}</p>
            </div>
          ))}
        </div>
      </div>
    </main>
  );
}
